#BEGIN_CHANNEL_DEFINITION
### Supported units ###
#Temperature
#  TemperatureInCelsius, // SI Default
#  TemperatureInKelvin,
#  TemperatureInFahrenheit,
#Pressure
#  PressureInBar,
#  PressureInPascal, // SI Default
#  PressureInPsia,
#Flow
#  FlowInLitersPerMinute, // SI Default
#  FlowInLitersPerHour,
#AbsHumidity
#  AbsHumidityInGrammPerLiter,
#  AbsHumidityInGrammPerMeters3, // SI Default
#  AbsHumidityInMilliGrammPerMeters3,
#Dimensionless
#  DimensionlessWithNoFactor, // SI Default for "Percent"
#  DimensionlessInPercent,
#  DimensionlessInPPM,
#  DimensionlessInPPB,
#  DimensionlessInOhms, // SI Default
#  DimensionlessInMilliVolts,
#  DimensionlessInVolts, // SI Default
#  DimensionlessInAmperes, // SI Default
#  DimensionlessInMilliAmperes

### Channel configuration (no spaces! case sensitive!) ###
#IN|Temperature1|TemperatureInCelsius
#IN|Temperature2|TemperatureInKelvin
#IN|Pressure1|PressureInPascal
#IN|Dimensionsless1|DimensionlessWithNoFactor
#IN|Dimensionsless2|DimensionlessInPercent
#IN|Constant1|Constant|PressureInPascal
#IN|Constant2|Constant|DimensionlessInPercent
#RETURN|TemperatureResult|TemperatureInCelsius
#OUT|D_Result1|DimensionlessWithNoFactor ||| NOT SUPPORTED
#OUT|P_Result|PressureInPascal ||| NOT SUPPORTED
#END_CHANNEL_DEFINITION

def executeByCSharp(data):
  Temperature1 = float(data['Temperature1'])
  Temperature2 = float(data['Temperature2'])
  Pressure1 = float(data['Pressure1'])
  Dimensionsless1 = float(data['Dimensionsless1'])
  Constant1 = float(data['Constant1'])
  Constant2 = float(data['Constant2'])
  #print(str(Temperature1) + ' / ' + str(Temperature2) + ' / ' + str(Pressure1) + ' / ' + str(Dimensionsless1))
  #print(str(Constant1) + ' / ' + str(Constant2))
  temperatureResult = Dimensionsless1 * 2 + (Temperature1 + Temperature2 + Pressure1 + Dimensionsless1) - (Constant1 + Constant2)
  return temperatureResult


#Debug script
#exampleData = {'Temperature1': '1', 'Temperature2': '2', 'Pressure1': '3', 'Dimensionsless1': '4', 'Constant1': '5', 'Constant2': '6'}  
#print executeByCSharp(exampleData)